<?php

// Wywietla informacje o zdjciu
// Zdjcie musi by w tym samym katalogu co aplikacja lub naley
// poda pen ciek dostpu do niego w postaci np:
//
// http://localhost/xmp.php?photo=/Users/shelley/Pictures/rainyday/nzuzu.jpg
//
// bez cieki dostpu aplikacja zaoy, e zdjcie znajduje si
// w katalogu biecym
//
// http://localhost/xmp.php?photo=nzuzu.jpg
//
// Aplikacja nie sprawdza, czy zdjcie istnieje lub czy jego nazwa jest poprawna

$file = $_GET['photo'];

$xmp = ee_extract_exif_from_pscs_xmp($file,1);

function ee_extract_exif_from_pscs_xmp ($filename,$printout=0) {
    
    // code by Pekka Saarinen http://photography-on-the.net, with modifications by Shelley Powers
    
    ob_start();
    readfile($filename);
    $source = ob_get_contents();
    ob_end_clean();
    
    $xmpdata_start = strpos($source,"<x:xmpmeta");
    $xmpdata_end = strpos($source,"</x:xmpmeta>");
    $xmplenght = $xmpdata_end-$xmpdata_start;
    $xmpdata = substr($source,$xmpdata_start,$xmplenght+12);

    // echo raw data
    echo $xmpdata . '<br />'; 
    $xmp_parsed = array();
   
    // Wybieranie danych
    $regexps = array(
    array("name" => "DC creator", "regexp" => "/<dc:creator>\s*<rdf:Seq>\s*<rdf:li>.+<\/rdf:li>\s*<\/rdf:Seq>\s*<\/dc:creator>/"),
    array("name" => "DC subject", "regexp" => "/<dc:subject>\s*<rdf:Bag>\s*<rdf:li>.+<\/rdf:li>\s*<\/rdf:Bag>\s*<\/dc:subject>/"),
    array("name" => "ISO", "regexp" => "/<exif:ISOSpeedRatings>\s*<rdf:Seq>\s*<rdf:li>.+<\/rdf:li>\s*<\/rdf:Seq>\s*<\/exif:ISOSpeedRatings>/"),
    array("name" => "DC title", "regexp" => "/<dc:title>\s*<rdf:Alt>\s*<rdf:li\\s+?(.+?)>.+<\/rdf:li>\s*<\/rdf:Alt>\s*<\/dc:title>/"),
    array("name" => "DC description", "regexp" => "/<dc:description>\s*<rdf:Alt>\s*<rdf:li\\s+?(.+?)>.+<\/rdf:li>\s*<\/rdf:Alt>\s*<\/dc:description>/")
    );
   
    // Porwnanie
    foreach ($regexps as $key => $k) {
            $name         = $k["name"];
            $regexp     = $k["regexp"];
            unset($r);
            preg_match ($regexp, $xmpdata, $r);
            $xmp_item = "";
            $xmp_item = @$r[0];
            array_push($xmp_parsed,array("item" => $name, "value" => $xmp_item));
    }
   
    // Drukuje dane
    if ($printout == 1) {
        foreach ($xmp_parsed as $key => $k) {
                $item         = $k["item"];
                $value         = $k["value"];
                print "<br><b>" . $item . ":</b> " . $value;

        }
    }

return ($xmp_parsed);

}
?>

